 
<?php $__env->startSection('title','SMS Gateway Settings'); ?>

<?php $__env->startSection('css'); ?>
<link href="<?php echo e(asset('public/backEnd')); ?>/assets/libs/select2/css/select2.min.css" rel="stylesheet" type="text/css" />
<style>
    /* Professional Card Styling */
    .card-box {
        background-color: #fff;
        padding: 1.5rem;
        box-shadow: 0 0.75rem 1.5rem rgba(18, 38, 63, .03);
        margin-bottom: 24px;
        border-radius: 0.25rem;
        border: 1px solid #edf2f9;
    }
    
    .card-header-custom {
        background: #f8f9fa;
        padding: 15px;
        border-bottom: 1px solid #eee;
        margin: -1.5rem -1.5rem 1.5rem -1.5rem;
        border-radius: 0.25rem 0.25rem 0 0;
        display: flex;
        align-items: center;
    }

    .card-header-custom h4 {
        margin: 0;
        font-size: 16px;
        font-weight: 700;
        color: #343a40;
        text-transform: uppercase;
    }

    /* --- [FIX] INPUT GROUP MERGING STYLES --- */
    /* এই অংশটি আপনার আইকন এবং ইনপুট ফিল্ডকে জোড়া লাগিয়ে রাখবে */
    .input-group {
        display: flex;
        flex-wrap: nowrap;
        align-items: stretch;
        width: 100%;
    }
    .input-group-prepend {
        margin-right: -1px; /* বর্ডার ডাবল হওয়া আটকাবে */
        display: flex;
    }
    .input-group-text {
        display: flex;
        align-items: center;
        padding: 0.375rem 0.75rem;
        margin-bottom: 0;
        font-size: .875rem;
        font-weight: 400;
        line-height: 1.5;
        color: #495057;
        text-align: center;
        white-space: nowrap;
        background-color: #f1f5f7; /* হালকা ব্যাকগ্রাউন্ড */
        border: 1px solid #ced4da;
        border-radius: 0.25rem 0 0 0.25rem; /* শুধু বাম পাশ গোল হবে */
    }
    .input-group > .form-control {
        position: relative;
        flex: 1 1 auto;
        width: 1%;
        min-width: 0;
        margin-bottom: 0;
        border-top-left-radius: 0; /* বাম পাশের কোনা সোজা হবে */
        border-bottom-left-radius: 0;
    }
    /* ---------------------------------------- */

    /* Custom Switch Toggle */
    .switch {
        position: relative;
        display: inline-block;
        width: 50px;
        height: 26px;
        margin-bottom: 0;
    }
    .switch input { opacity: 0; width: 0; height: 0; }
    .slider {
        position: absolute;
        cursor: pointer;
        top: 0; left: 0; right: 0; bottom: 0;
        background-color: #ccc;
        transition: .4s;
        border-radius: 34px;
    }
    .slider:before {
        position: absolute;
        content: "";
        height: 18px; width: 18px;
        left: 4px; bottom: 4px;
        background-color: white;
        transition: .4s;
        border-radius: 50%;
    }
    input:checked + .slider { background-color: #28a745; }
    input:focus + .slider { box-shadow: 0 0 1px #28a745; }
    input:checked + .slider:before { transform: translateX(24px); }

    /* Code Block Styling */
    .code-block {
        background: #2d2d2d;
        color: #ccc;
        padding: 15px;
        border-radius: 5px;
        font-family: 'Courier New', Courier, monospace;
        font-size: 13px;
        overflow-x: auto;
        margin-top: 10px;
    }
    .keyword { color: #cc99cd; }
    .string { color: #7ec699; }
    .variable { color: #f08d49; }
    
    .instruction-list li {
        margin-bottom: 8px;
        font-size: 14px;
        color: #555;
    }
    .badge-soft-primary {
        background-color: rgba(59,130,246,.1);
        color: #3b82f6;
        padding: 3px 8px;
        border-radius: 4px;
        font-size: 12px;
    }
</style>
<?php $__env->stopSection(); ?> 

<?php $__env->startSection('content'); ?>
<div class="container-fluid">
    
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-flex align-items-center justify-content-between" style="padding: 20px 0;">
                <div class="d-flex align-items-center">
                    <img src="<?php echo e(asset('public/frontEnd/images/creativedesignbd.png')); ?>" alt="Logo" style="height: 40px; margin-right: 15px; border-radius:4px;">
                    <h4 class="mb-0 font-size-18">SMS Gateway Integration</h4>
                </div>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="javascript: void(0);">Dashboard</a></li>
                        <li class="breadcrumb-item active">SMS Settings</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xl-7">
            <div class="card-box">
                <div class="card-header-custom">
                    <i class="fas fa-cogs" style="margin-right: 10px; color: #556ee6;"></i>
                    <h4>Configuration Settings</h4>
                </div>

                <form action="<?php echo e(route('smsgeteway.update')); ?>" method="POST" data-parsley-validate="" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="id" value="<?php echo e($sms->id); ?>">

                    <div class="form-group mb-4">
                        <label for="api_key" class="form-label font-weight-bold">API Key <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><i class="fas fa-key"></i></span>
                            </div>
                            <input type="text" class="form-control <?php $__errorArgs = ['api_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                name="api_key" value="<?php echo e($sms->api_key); ?>" id="api_key" 
                                placeholder="Ex: C20023485e9XXXXXX" required />
                        </div>
                        <small class="text-muted">Bulksmsbd.net প্যানেল থেকে প্রাপ্ত আপনার গোপন API Key টি দিন।</small>
                        <?php $__errorArgs = ['api_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback d-block" role="alert"><strong><?php echo e($message); ?></strong></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <div class="form-group mb-4">
                        <label for="admin_phone_list" class="form-label font-weight-bold">Admin Notification Numbers</label>
                        <div class="input-group">
                            <div class="input-group-prepend">
                                <span class="input-group-text"><i class="fas fa-mobile-alt"></i></span>
                            </div>
                            <input type="text" class="form-control <?php $__errorArgs = ['admin_phone_list'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                name="admin_phone_list" id="admin_phone_list"
                                value="<?php echo e(old('admin_phone_list', env('ADMIN_PHONE_LIST', $sms->admin_phone ?? ''))); ?>" 
                                placeholder="01711111111, 01822222222" />
                        </div>
                        <small class="text-muted">কমা (,) ব্যবহার করে একাধিক নম্বর যুক্ত করতে পারেন।</small>
                        <?php $__errorArgs = ['admin_phone_list'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <span class="invalid-feedback d-block" role="alert"><strong><?php echo e($message); ?></strong></span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>

                    <hr class="mt-4 mb-4">
                    <h5 class="font-size-14 mb-3 text-uppercase text-muted"><i class="fas fa-bell mr-2"></i>Automation Triggers</h5>

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <div class="d-flex justify-content-between align-items-center border p-3 rounded bg-light">
                                <div>
                                    <h6 class="mb-1">Gateway Status</h6>
                                    <small class="text-muted">Enable/Disable SMS System</small>
                                </div>
                                <label class="switch">
                                    <input type="checkbox" value="1" <?php if($sms->status==1): ?>checked <?php endif; ?> name="status" />
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>

                        <div class="col-md-6 mb-3">
                            <div class="d-flex justify-content-between align-items-center border p-3 rounded">
                                <div>
                                    <h6 class="mb-1">Order Confirmation</h6>
                                    <small class="text-muted">SMS when order placed</small>
                                </div>
                                <label class="switch">
                                    <input type="checkbox" value="1" <?php if($sms->order==1): ?>checked <?php endif; ?> name="order" />
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>

                        <div class="col-md-6 mb-3">
                            <div class="d-flex justify-content-between align-items-center border p-3 rounded">
                                <div>
                                    <h6 class="mb-1">Forgot Password</h6>
                                    <small class="text-muted">OTP for password reset</small>
                                </div>
                                <label class="switch">
                                    <input type="checkbox" value="1" <?php if($sms->forget_pass==1): ?>checked <?php endif; ?> name="forget_pass" />
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>

                        <div class="col-md-6 mb-3">
                            <div class="d-flex justify-content-between align-items-center border p-3 rounded">
                                <div>
                                    <h6 class="mb-1">User Registration</h6>
                                    <small class="text-muted">Send generated password</small>
                                </div>
                                <label class="switch">
                                    <input type="checkbox" value="1" <?php if($sms->password_g==1): ?>checked <?php endif; ?> name="password_g" />
                                    <span class="slider round"></span>
                                </label>
                            </div>
                        </div>
                    </div>

                    <div class="mt-4">
                        <button type="submit" class="btn btn-primary btn-lg waves-effect waves-light px-5">
                            <i class="fas fa-save mr-1"></i> Save Configuration
                        </button>
                    </div>
                </form>
            </div>
        </div>

        <div class="col-xl-5">
            <div class="card-box bg-white border-info">
                <div class="card-header-custom" style="background: #eef2ff;">
                    <i class="fas fa-book-reader" style="margin-right: 10px; color: #556ee6;"></i>
                    <h4>API Integration Guide</h4>
                </div>
                
                <div class="p-2">
                    <h5 class="text-primary mb-3">কিভাবে সেটআপ করবেন?</h5>
                    <ul class="instruction-list pl-3">
                        <li><strong>ধাপ ১:</strong> প্রথমে <a href="https://www.creativedesign.com.bd/login" target="_blank">www.creativedesign.com.bd</a> এ লগইন করুন।</li>
                        <li><strong>ধাপ ২:</strong> মেনু থেকে <code>এসএমএস সার্ভিস থেকে এপিআই ডকুমেন্টেশন</code> অপশনে যান।</li>
                        <li><strong>ধাপ ৩:</strong> সেখান থেকে আপনার <span class="badge badge-soft-primary">API KEY</span> টি কপি করুন।</li>
                        <li><strong>ধাপ ৪:</strong> বাম পাশের ফর্মে API Key টি পেস্ট করুন এবং সেভ করুন।</li>
                    </ul>

                    <h5 class="text-primary mt-4 mb-3">API Parameters</h5>
                    <table class="table table-sm table-bordered font-size-13">
                        <thead class="thead-light">
                            <tr>
                                <th>Parameter</th>
                                <th>Value</th>
                                <th>Description</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td><code>api_key</code></td>
                                <td>String</td>
                                <td>Your unique API key</td>
                            </tr>
                            <tr>
                                <td><code>number</code></td>
                                <td>88017...</td>
                                <td>Receiver Number</td>
                            </tr>
                            <tr>
                                <td><code>message</code></td>
                                <td>Text</td>
                                <td>SMS Content</td>
                            </tr>
                        </tbody>
                    </table>

                    <h5 class="text-primary mt-4 mb-2">PHP Integration Example</h5>
                    <p class="text-muted font-size-12 mb-2">আপনার প্রজেক্টের অন্য কোথাও ম্যানুয়ালি ব্যবহার করতে চাইলে:</p>
                    
                    <div class="code-block">
<pre>
<span class="keyword">$url</span> = <span class="string">"https://www.creativedesign.com.bd/api/smsapi"</span>;
<span class="keyword">$data</span> = [
  <span class="string">"api_key"</span> => <span class="string">"YOUR_API_KEY"</span>,
  <span class="string">"type"</span> => <span class="string">"text"</span>,
  <span class="string">"number"</span> => <span class="string">"88017XXXXXXXX"</span>,
  <span class="string">"message"</span> => <span class="string">"Test SMS"</span>
];

<span class="keyword">$ch</span> = curl_init();
curl_setopt(<span class="keyword">$ch</span>, CURLOPT_URL, <span class="keyword">$url</span>);
curl_setopt(<span class="keyword">$ch</span>, CURLOPT_POST, 1);
curl_setopt(<span class="keyword">$ch</span>, CURLOPT_POSTFIELDS, <span class="keyword">$data</span>);
curl_setopt(<span class="keyword">$ch</span>, CURLOPT_RETURNTRANSFER, true);
<span class="keyword">$response</span> = curl_exec(<span class="keyword">$ch</span>);
curl_close(<span class="keyword">$ch</span>);
</pre>
                    </div>
                </div>
            </div>
        </div>
        </div>
    </div>
<?php $__env->stopSection(); ?> 

<?php $__env->startSection('script'); ?>
<script src="<?php echo e(asset('public/backEnd/')); ?>/assets/libs/parsleyjs/parsley.min.js"></script>
<script src="<?php echo e(asset('public/backEnd/')); ?>/assets/js/pages/form-validation.init.js"></script>
<script src="<?php echo e(asset('public/backEnd/')); ?>/assets/libs/select2/js/select2.min.js"></script>
<script>
    $(document).ready(function () {
        $(".select2").select2();
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backEnd.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/foodkiac/public_html/resources/views/backEnd/apiintegration/sms_manage.blade.php ENDPATH**/ ?>